/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.api.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class EnumProperty
extends TeamProperty<String> {
    private final List<String> values;
    private final Map<String, class_2561> names;

    public EnumProperty(class_2960 id, Supplier<String> def, List<String> values, Map<String, class_2561> names) {
        super(id, def);
        this.values = values;
        this.names = names;
    }

    public <T> EnumProperty(class_2960 id, NameMap<T> nameMap) {
        this(id, () -> nameMap.getName(nameMap.defaultValue), nameMap.keys, EnumProperty.buildMap(nameMap));
    }

    private static <T> Map<String, class_2561> buildMap(NameMap<T> nameMap) {
        HashMap<String, class_2561> res = new HashMap<String, class_2561>();
        nameMap.forEach(val -> res.put(nameMap.getName(val), nameMap.getDisplayName(val)));
        return res;
    }

    static EnumProperty fromNetwork(class_2960 id, class_2540 buf) {
        String def = buf.method_10800(Short.MAX_VALUE);
        List values = buf.method_34066(b -> b.method_10800(Short.MAX_VALUE));
        Map names = buf.method_34067(b -> b.method_10800(Short.MAX_VALUE), class_2540::method_10808);
        return new EnumProperty(id, () -> def, values, names);
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.ENUM;
    }

    @Override
    public Optional<String> fromString(String string) {
        return Optional.of(string);
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10788((String)this.getDefaultValue(), Short.MAX_VALUE);
        buf.method_34062(this.values, class_2540::method_10814);
        buf.method_34063(this.names, class_2540::method_10814, class_2540::method_10805);
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<String> value) {
        config.addEnum(this.id.method_12832(), (Object)((String)value.value), value.consumer, NameMap.of((Object)((String)this.getDefaultValue()), this.values).name(s -> this.names.getOrDefault(s, (class_2561)class_2561.method_43470((String)s))).create());
    }

    @Override
    public class_2520 toNBT(String value) {
        return class_2519.method_23256((String)value);
    }

    @Override
    public Optional<String> fromNBT(class_2520 tag) {
        if (tag instanceof class_2519) {
            return Optional.of(tag.method_10714());
        }
        return Optional.empty();
    }
}

